<?php

require_once'./php/klasy/drzewko.php';

class galeria extends drzewko
{
	const MIN = 200;
	private $height = 200;
	
	public function setThumb(array $file, $flaga)
	{
		include_once 'Asido/class.asido.php';
		
		asido::driver('gd');

		$thumb = asido::image($file['path'].$file['name'],$file['path'].'/min/200'.$file['name']);
		
		asido::height($thumb,$this->height);
		
		$thumb->save(ASIDO_OVERWRITE_ENABLED);
	}
	
public function stworz_miniaturki($zdjecie,$katalog,$tmp_pliku,$x,$y) {
		
		$miniaturka = imagecreatefromjpeg($katalog.$zdjecie);
		list($ow, $oh) = getimagesize($tmp_pliku);
		$big = imagecreatefromjpeg($tmp_pliku);
		$thumb = imagecreatetruecolor($x,$y);
		$white = imagecolorallocate($thumb, 255, 255, 255);
		imagefilledrectangle($thumb, 0, 0, $x, $y, $white);
		
		$xskala=$ow/$x;
		$yskala=$oh/$y;
		
		if ($yskala<1 && $xskala<1)
		{
			$dis_w = round(($x-$ow)/2);
			$dis_h = round(($y-$oh)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $ow, $oh, $ow, $oh);
		}
		else
		{
			$ramka_w=$x;
			$ramka_h=$y;	
			if ($yskala>$xskala)
			{
				$x = round($ow * (1/$yskala));
				$y = round($oh * (1/$yskala));
			}
			else 
			{
				$x = round($ow * (1/$xskala));
				$y = round($oh * (1/$xskala));
			}	
			
			$dis_w = round(($ramka_w-$x)/2);
			$dis_h = round(($ramka_h-$y)/2);
			imagecopyresampled($thumb, $big, $dis_w, $dis_h, 0, 0, $x, $y, $ow, $oh);
		}
		imagejpeg($thumb, $katalog.'min/'.$x.$zdjecie, 100);
	}

	public function dodaj_plikAkcja()
	{
		$smarty = Zend_Registry::get('smarty');

		$tab = explode('.',$_FILES['zdjecie']['name']);
			
		if($tab[1]!='jpg' && $tab[1]!='jpeg' && $tab[1]!='JPG' && $tab[1]!='JPEG')
		{
			$error = array();
			$error['typ'] = 'error';
			$error['tekst'] = 'Błąd. Niewłaściwy format pliku. Wymagane pliki *.<strong>jpg</strong>. <a href="?p='.(int)$_GET['p'].'&a=6">Spróbuj ponownie</a>';
			$smarty->assign('komunikat',$error);
		}
			
		else
		{
			if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])throw new Exception('Nie odświeżaj strony!');
			$_SESSION['form'] = $_POST['r'];
				
			$id = $_POST['kategoria'];
				
			global $_FILES;

			$NazwaPliku = $_FILES['zdjecie']['name'];
			$RozmiarPliku = $_FILES['zdjecie']['size'];
			$TymczasowaNazwaPliku = $_FILES['zdjecie']['tmp_name'];
			$Blad = $_FILES['zdjecie']['error'];
				
			$nameOfFile = $NazwaPliku;
			$NazwaPliku = date('Ydmhis').Index::usun_ogonki(str_replace(" ", "_", $NazwaPliku));
			$katalog = '../galeria/'.$id.'/';
			$katalog_min = $katalog.'min/';
				
			if(!is_dir($katalog))
			{
				mkdir($katalog);
				chmod($katalog,0777);
			}
			if(!is_dir($katalog_min))
			{
				mkdir($katalog_min);
				chmod($katalog_min,0777);
			}
				
			if(is_uploaded_file($TymczasowaNazwaPliku))
			{
				if(move_uploaded_file($TymczasowaNazwaPliku, $katalog.$NazwaPliku))
				{
					chmod($katalog.$NazwaPliku,0755);
					
					//$this->stworz_miniaturki($NazwaPliku, $katalog,$katalog.$NazwaPliku,self::MIN,self::MIN);
					
					//$array = array('name'=> $NazwaPliku,'path'=>$katalog.$NazwaPliku);
					
					$this->setThumb(array('name'=> $NazwaPliku,'path'=>$katalog),0);
					
					$dane['kategoria'] = $id;
					$dane['nazwa'] = $NazwaPliku;
					$dane['nazwa_prawdziwa'] = $nameOfFile;
					$dane['gdzie'] = 'g';
					
					$db = Zend_Registry::get('db');
						
					$db->insert(Index::dbPrefiks.'obrazki',$dane);
					//echo ' Plik: <b>'.$NazwaPliku.'</b> został poprawnie dodany.<br />';
					$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$dane['nazwa_prawdziwa'].'</b> został poprawnie dodany.'));
					$result = true;
				}

				else
				{
					$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd1: ".$Blad));
				}
			}

			else
			{
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd2: ".$katalog));
			}

			$this->menu();
			return $result;
		}
	}

	public function getKategoria()
	{
		$db = Zend_Registry::get('db');

		$sql ='SELECT id, nazwa FROM '.Index::dbPrefiks.'drzewko';
		$results = $db->fetchAll($sql);
			
		return $results;
	}

	public function dodaj_plikForm()
	{
		if(isset($_GET['id_s']))$id_s = (int)$_GET['id_s'];
		if(isset($_GET['nr']))$id = (int)$_GET['nr'];
			
		$new = new generatorFormularzy('Galeria','?p=6&a=5', 'POST', 'enctype="multipart/form-data"');
		$new->poczatekForm();
		//$new->text('Wybierz produkt: '.$this->getKategoria().'<br /><br />');
		$new->select('kategoria', $this->displayTreeSelect(15), '', '', true, 'Wybierz produkt');
		$new->checkbox('Tytułowe', !empty($tab['tytulowe']) ? $tab['tytulowe'] : '');
		$new->input('Zdjęcie', 'file', '', '', '', true);
		$new->text('<br>');
		$new->input('submit', 'submit', 'Dodaj plik', '', 'searchbutton', false);
		$new->input('r', 'hidden', time(), '', '', false);
		$new->koniecForm();

	}

	public function listaAdmin()
	{
		try
		{
			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');
				
			$sql="SELECT o.id oid,o.nazwa nazwa,d.id did, d.nazwa kategoria, o.nazwa_prawdziwa nazwa_prawdziwa FROM ".Index::dbPrefiks."obrazki o join ".Index::dbPrefiks."drzewko d on o.kategoria = d.id WHERE o.gdzie='g'";
			$result = $db->fetchAll($sql);
			$smarty->assign('lista', $result);
			$smarty->assign('MIN',self::MIN);
				
		}
		catch (Zend_Db_Adapter_Exception $e)
		{
			przechwyc_blad($e);
		}
			
		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	/*
	 * Funkcja usuwajaca informacje z bazy o zdjęciu oraz usuwiająca fizycznie plik z katalogu;
	 */

	public function usunObrazek($id, $id_strony, $nazwa)
	{
		$db = Zend_Registry::get('db');
		$db->delete(Index::dbPrefiks.'obrazki', 'id='.$id);
		$smarty = Zend_Registry::get('smarty');	
		@unlink('../galeria/'.$id_strony.'/min/'.$nazwa);
		@unlink('../galeria/'.$id_strony.'/'.$nazwa);
		
		$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik został poprawnie usunięty.'));

		//$this->menu();
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');
		$smarty->assign('submenu', array(0 => array('link' => '?p=6&a=6', 'tekst' => 'Dodaj nowe zdjęcie do galerii')));
		$this->listaAdmin();
	}

	public function editOpisForm()
	{
		$db = Zend_Registry::get('db');
		$smarty = Zend_Registry::get('smarty');
			
		if(empty($_POST))
		{
			$sql = 'select opis from '.Index::dbPrefiks.'obrazki where id='.(int)$_GET['nr'];
			$opis = $db->fetchRow($sql);

			$new = new generatorFormularzy('Galeria','?p=6&a=7', 'POST');
			$new->poczatekForm();
			//$new->text('Wybierz produkt: '.$this->getKategoria().'<br /><br />');
			$new->textarea('Opis', 5, 40, '', $opis['opis']);
			$new->input('submit', 'submit', 'Zapisz', '', 'searchbutton', false);
			$new->input('r', 'hidden', time(), '', '', false);
			$new->input('idd', 'hidden', (int)$_GET['nr'], '', '', false);
			$new->koniecForm();
				
			/*
			 $form = '<center>
			 <form action="?p=6&a=7" method="POST">
			 Opis: <br /><br /><textarea id="opis" name="opis">'.$opis['opis'].'</textarea><br /><br />
			 <input id="submit" type="submit" value="Zapisz" />
			 <input id="r" name="r" type="hidden" value="'.time().'" />
			 <input id="idd" name="idd" type="hidden" value="'.(int)$_GET['nr'].'" />
			 </form></center>';
			 echo $form;
			 */
		}
		else
		{
			$filtr = new Zend_Filter_StripTags();
				
			$dane = array();
			$dane['opis'] = $filtr->filter($_POST['opis']);
				
			$db->update(Index::dbPrefiks.'obrazki',$dane,'id='.(int)$_POST['idd']);
			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=>'<div class="kom">Opis został zmieniony prawidłowo.</div>'));
			$this->menu();
		}
	}

	public function zamienObrazek()
	{
		$id = (int)$_GET['nr'];
			
		$sql = "SELECT * FROM ".Index::dbPrefiks."obrazki WHERE id=".$id;
		$db = Zend_Registry::get('db');
			
		$results = $db->fetchAll($sql);
			
		$this->usunObrazek($id, $results[0]['id_strony'], $results[0]['nazwa']);
		$this->dodaj_plikForm();
	}
	
	public static function getListOfImage($menu_id = null)
	{
		$sql = 'select id, nazwa_prawdziwa nazwa from '.Index::dbPrefiks.'obrazki WHERE kategoria='.(int)$menu_id;
				
		$db = Zend_Registry::get('db');
		
		return $db->fetchAll($sql);
	} 
	
	public static function getImage($id)
	{
		$sql = 'select * from '.Index::dbPrefiks.'obrazki WHERE id='.(int)$id;
				
		$db = Zend_Registry::get('db');
		
		return $db->fetchRow($sql);
	}
}

?>