<?php

/*
* Klasa odpowiadająca za upload plików
*/

include_once './php/klasy/drzewko.php';
class File extends drzewko
{
	public $_tab = array();
	private $_katalog;
	private $_table = 'files';

	const PAGE = 12;
	const DIR = '../files';
	public function settings($katalog = null, $rozszerzenie = null)
	{
		try
		{

			if(!empty($katalog))
			{
				$this->_katalog = self::DIR.'/'.$katalog;

				if(!is_dir($this->_katalog))
				{
					mkdir($this->_katalog);
					chmod($this->_katalog,0777);

				}
			}
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function form($tab)
	{

		$new = new generatorFormularzy('Pliki','?p='. self::PAGE .'&a=3', 'POST', 'enctype="multipart/form-data"');
		$new->poczatekForm();

		$new->inupt('Tytul', 'text',!empty($tab['title']) ? $tab['title'] : '','','textlong');
	//	$new->select('Kategoria', $this->displayTreeSelect(), $tab['kategoria'], '', true, 'Wybierz kategorię');
		$new->select('Produkt', $this->products(), $tab['product']);
		$new->input('Plik', 'file', '', '', '', true);
		$new->text('<br>');
		if(!isset($tab['id']))
		$new->input('submit', 'submit', 'Dodaj plik', '', 'searchbutton', false);
		else 
		$new->input('submit', 'submit', 'Zmień plik', '', 'searchbutton', false);
		$new->input('r', 'hidden', time(), '', '', false);
		if(isset($tab['id']))
		$new->input('id', 'hidden', $tab['id'], '', '', false);
		$new->koniecForm();
	}

	/*
	* File upload function
	*/

	public function add()
	{
		try
		{
			global $_FILES;
			$smarty = Zend_Registry::get('smarty');

			$errors = array('1'=>'The file is bigger than this PHP installation allows',
			'2'=>'The file is bigger than this form allows',
			'3'=>'Only part of the file was uploaded',
			'4'=>'No file was uploaded');
			if(is_uploaded_file($_FILES['plik']['tmp_name']))
			{
				$this->valid($_FILES['plik']['name']);

				$nameOfFile = date('Ydmhis').Index::usun_ogonki(str_replace(" ", "_", $_FILES['plik']['name']));
				if(move_uploaded_file($_FILES['plik']['tmp_name'], '../files/'.$nameOfFile))
				{
					chmod( '../files/'.$nameOfFile,0755);
					$dane['name'] = $nameOfFile;
					$dane['true_name'] = $_FILES['plik']['name'];
				}

			}

			$dane['title'] 		= $_POST['tytul'];
			$dane['product'] 	= (int)$_POST['produkt'];

			$db = Zend_Registry::get('db');
			if(!isset($_POST['id'])){
				$db->insert(Index::dbPrefiks.$this->_table, $dane);
				if(isset($dane['true_name']))
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$dane['true_name'].'</b> został poprawnie dodany.'));
				else 
				$smarty->assign('komunikat', array('typ'=>'error', 'tekst'=> "Wystąpił błąd: ".$_FILES['plik']['name']));
			}
			else {
				$db->update(Index::dbPrefiks.$this->_table, $dane,'id='.(int)$_POST['id']);
				$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik został poprawnie zmieniony.'));
			}

			$this->menu();

		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	/*
	* File delete functions
	*/

	public function delete($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('Brak identyfikatora pliku.');
			}

			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');

			$sql = 'select name, true_name from '.Index::dbPrefiks.$this->_table.' WHERE id='.(int)$id;
			$plik = $db->fetchRow($sql);

			$db->delete(Index::dbPrefiks.$this->_table,'id='.(int)$id);
			unlink( '../files/'.$plik['name']);

			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> 'Plik <b>'.$plik['true_name'].'</b> został poprawnie usuniety.'));
			$this->menu();
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function listOfFiles()
	{
		try
		{
			
			$sql = 'select f.*, p.nazwa_pl as knazwa
			from '.Index::dbPrefiks.$this->_table.' f 
			left join '.Index::dbPrefiks.'products p on f.product=p.id 
			ORDER BY f.id DESC';

			$db = Zend_Registry::get('db');

			return $db->fetchAll($sql);
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	/*
	* Valid function
	*/

	public function valid($fileName)
	{
		try
		{
			$file = explode('.',$fileName);

			$ext = $file[count($file)-1];

			if(!in_array(strtolower($ext), $this->_tab))
			{
				throw new Exception('Nie prawidłowy format pliku.');
			}
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');
		$smarty->assign('submenu', array(0 => array('link' => '?p='. self::PAGE .'&a=2', 'tekst' => 'Dodaj nowy plik')));
		$smarty->assign('lista',$this->listOfFiles());
	}

	public static function getListOfFiles()
	{
		$sql = 'select f.id id, concat(d.nazwa_pl,"=>"f.true_name) nazwa from '.Index::dbPrefiks.$this->_table.' f join '.Index::dbPrefiks.'drzewko d on f.kategoria=d.id ORDER BY name';

		$db = Zend_Registry::get('db');

		return $db->fetchAll($sql);
	}

	public function news() {
		$sql = "select id, tytul_pl as nazwa from " .Index::dbPrefiks."aktualnosci ORDER BY nazwa ASC";

		$db = Zend_Registry::get('db');

		return $db->fetchAll($sql);
	}
	public function products() {
		$sql = "select id, nazwa_pl as nazwa from " .Index::dbPrefiks."products ORDER BY nazwa ASC";

		$db = Zend_Registry::get('db');

		return $db->fetchAll($sql);
	}
	public function edit($id){
		$sql = "select * from " .Index::dbPrefiks."files WHERE id=$id";
		$db = Zend_Registry::get('db');
		$this->form($db->fetchRow($sql));
	}
}
?>