<?php
session_start();

define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		* bootstrap
		*/

		session_cache_limiter("private_no_expire");

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");

		error_reporting(E_ALL);

		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'cms/library' . PATH_SEPARATOR . get_include_path());
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./cms/config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./cms/config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();


		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);

		$db->query('SET NAMES utf8');
		$db->query('SET CHARACTER SET utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);

		include_once('Smarty/Smarty.class.php');

		$tpl = new Smarty;
		$tpl->template_dir = './templates/';
		$tpl->compile_dir = './templates_c/';

		$tpl->register_modifier('ss', 'stripslashes');
		$tpl->register_modifier('url', 'Index::toPermalink');

		$registry->set('tpl', $tpl);

		$this->getContent();
	}

	public static function przechwyc_blad($e)
	{
		$smarty = Zend_Registry::get('tpl');

		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());

		echo $e->getMessage();
	}

	function randomString($length){
		static $srand;
		$result = '';
		if($srand != true){
			$srand = true;
			srand((double)microtime()*1000000);
		}
		$chars = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for($i=0; $i<$length; $i++){
			$result .= substr($chars,rand(0,strlen($chars)-1),1);
		}
		return $result;
	}


	private function authentication($login,$password) {
		$filtr = new Zend_Filter_StripTags();
		$login = $filtr->filter($login);
		$password = md5($filtr->filter($password));
		$db = Zend_Registry::get('db');
		$I = $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."users WHERE nazwa = '$login' AND haslo='$password'");

		if(!empty($I)){
			$_SESSION['user'] = $I;
			return true;
		}
		else {
			return false;
		}
	}

	private function check_mail_syntax($email)
	{
		$to_work_out = explode("@", $email);
		if (!isset($to_work_out[0])) return FALSE;
		if (!isset($to_work_out[1])) return FALSE;

		$pattern_local =  '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
		$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';
		$match_local = eregi($pattern_local, $to_work_out[0]);
		$match_domain = eregi($pattern_domain, $to_work_out[1]);

		if ($match_local && $match_domain) {
			return TRUE;
		}
		return FALSE;
	}

	private function checkEmpty($string){
		$string = str_replace(' ','',$string);
		$string = strip_tags($string);
		if(strlen($string) > 0)
		return false;
		return true;
	}

	private function registration($data){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');
		$err = 0;
		$filtr 				= 	new Zend_Filter_StripTags();
		$dane['nazwa'] 	 	= 	$filtr->filter($data['_login']);
		$dane['imie']	 	= 	$filtr->filter($data['_name']);
		$dane['nazwisko'] 	=   $filtr->filter($data['_surname']);
		$dane['e-mail']		=	$filtr->filter($data['_email']);
		$dane['rola']		=	'user';
		$dane['type']		=	2;

		if(!$this->checkEmpty($dane['nazwa']) && !$this->checkEmpty($dane['e-mail'])){
			if($this->check_mail_syntax($dane['e-mail'])){
				$I = $db->fetchRow("SELECT id FROM ".Index::dbPrefiks."users WHERE `nazwa` = '".$dane['nazwa']."' or `e-mail` = '".$dane['e-mail']."'");
				if((int)$I['id'] > 0){
					$tpl->assign('err',3);
					$err = 1;
				}
				else {
					$password = $this->randomString(8);

					$smarty = new Smarty;
					$smarty->compile_check = true;
					$smarty->debugging = false;
					$smarty->assign('dane',$dane);
					$smarty->assign('password',$password);
					$body = $smarty->fetch('reg_email.tpl');

					$dane['haslo'] =md5($password);

					$mail = new Zend_Mail('iso-8859-2');
					$mail->setBodyHtml($body);
					$mail->setFrom('rejestracja@marsel.pl', 'Marsel');
					$mail->addTo($dane['e-mail'], $dane['nazwa']);
					$mail->setSubject('Rejestracja Marsel');
					if($mail->send()){
						$tpl->assign('reg_ok',1);
						$db->insert(Index::dbPrefiks.'users',$dane);
					}
					else {
						$tpl->assign('err',4);
						$err = 1;
					}
				}
			}
			else {
				$tpl->assign('err',2);
				$err = 1;
			}
		}
		else{
			$tpl->assign('err',1);
			$err = 1;
		}
		$tpl->assign('error',$err);

	}

	private function newsletter($email){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		$filtr 				= 	new Zend_Filter_StripTags();
		$email = $filtr->filter($email);

		$I = $db->fetchRow("
		SELECT count(*) AS num 
		FROM ".Index::dbPrefiks."newsletter_users 
		WHERE `e-mail` = '$email'");

		switch($I['num']){
			case 1:
				$db->delete(Index::dbPrefiks.'newsletter_users',"`e-mail`='".$email."'");
				$tpl->assign('let_ok',2);
				break;
			default:
				if($this->check_mail_syntax($email)){
					$data['e-mail'] = $email;
					$data['date'] = time();
					$db->insert(Index::dbPrefiks.'newsletter_users', $data);
					$tpl->assign('let_ok',1);
				}
				else {
					$tpl->assign('let_error',1);
				}
				break;
		}
	}

	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);

		$white = imagecolorallocate($dimg, 255, 255, 255);
		imagefill($dimg, 0, 0, $white);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}

		return $result;
	}

	function send_add(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		$key = '';

		$allowedExtensions 	= array('jpg','gif','png','jpeg');
		$allowedTypes 		= array('image/jpeg','image/gif','image/png','image/jpg');

		if(isset($_POST['add'])){
			$filtr 	= 	new Zend_Filter_StripTags();
			$err	=	0;
			if(isset($_POST['_accept']) && $_POST['_accept'] == 1){

				$dane['nazwa']			=	$filtr->filter($_POST['_name']);
				$dane['miasto']			=	$filtr->filter($_POST['_city']);
				$dane['ulica']			=	$filtr->filter($_POST['_street']);
				$dane['telefon']		=	$filtr->filter($_POST['_phone']);
				$dane['www']			=	$filtr->filter($_POST['_www']);
				$dane['email']			=	$filtr->filter($_POST['_email']);
				$dane['kod']			=	$filtr->filter($_POST['_prefix']);
				$dane['fax']			=	$filtr->filter($_POST['_fax']);
				$dane['aktywny']		=	'nie';
				$dane['kategoria']		=	(int)$_POST['_cat'];
				$dane['wojewodztwo']	=	(int)$_POST['_woj'];
				$dane['type']			=	(int)$_POST['_type'];
				$dane['opis']			=	$filtr->filter($_POST['_desc']);

				$dane['f_nazwa']			=	$filtr->filter($_POST['_f_name']);
				$dane['f_nip']				=	$filtr->filter($_POST['_f_nip']);
				$dane['f_adres']			=	$filtr->filter($_POST['_f_address']);
				$dane['f_kod']				=	$filtr->filter($_POST['_f_prefix']);
				$dane['f_miasto']			=	$filtr->filter($_POST['_f_city']);
				$dane['f_telefon']			=	$filtr->filter($_POST['_f_phone']);

				foreach ($dane as $d){
					$key .= $d.'-';
				}

				if(isset($_SESSION['checksum'])){
					if($_SESSION['checksum'] == $key)
					return 18;
				}
				$_SESSION['checksum'] = $key;

				if($this->checkEmpty($dane['nazwa'])){
					return 1;
				}
				if($this->checkEmpty($dane['miasto'])){
					return 2;
				}
				if($this->checkEmpty($dane['kod'])){
					return 3;
				}
				if($this->checkEmpty($dane['ulica'])){
					return 4;
				}
				if($this->checkEmpty($dane['telefon'])){
					return 5;
				}
				if(!$this->check_mail_syntax($dane['email'])){
					return 6;
				}
				if($dane['kategoria'] == 0){
					return 7;
				}
				if($dane['wojewodztwo'] == 0){
					return 8;
				}
				if($dane['type'] == 0){
					return 11;
				}
				if($this->checkEmpty($dane['f_nazwa'])){
					return 12;
				}
				if($this->checkEmpty($dane['f_nip'])){
					return 13;
				}
				if($this->checkEmpty($dane['f_adres'])){
					return 14;
				}
				if($this->checkEmpty($dane['f_kod'])){
					return 15;
				}
				if($this->checkEmpty($dane['f_miasto'])){
					return 16;
				}
				if($this->checkEmpty($dane['f_telefon'])){
					return 17;
				}



				if(is_uploaded_file($_FILES['_logo']['tmp_name'])){
					$file_source	=	$_FILES['_logo']['tmp_name'];
					$file_type 		= 	$_FILES['_logo']['type'];
					$file_error		=	$_FILES['_logo']['error'];
					$file_name		=	md5(time()).$_FILES['_logo']['name'];

					$file_extension	=	explode('.',$file_name);
					$file_extension	=	strtolower($file_extension[count($file_extension)-1]);

					if($file_error == 0) {
						if(in_array($file_type,$allowedTypes) && in_array($file_extension,$allowedExtensions)){
							move_uploaded_file($file_source, 'galeria/'.$file_name);
							$this->cropImage('galeria/'.$file_name,'galeria/min/'.$file_name,150,60);
							$dane['zdjecie']	=	$file_name;
						}
						else {
							return 10;
						}
					}
					else {
						return 10;
					}
					unset($_FILES['_logo']);
				}

				$db->insert(Index::dbPrefiks.'products', $dane);
				$id = $db->lastInsertId();

				if(isset($_FILES)){
					$fl = 0;
					foreach ($_FILES as $key => $file){
						$fl++;
						if(is_uploaded_file($file['tmp_name'])){
							$file_source	=	$file['tmp_name'];
							$file_type 		= 	$file['type'];
							$file_error		=	$file['error'];
							$file_name		=	md5(time()).$file['name'];

							$file_extension	=	explode('.',$file_name);
							$file_extension	=	strtolower($file_extension[count($file_extension)-1]);

							if($file_error == 0) {
								if(in_array($file_type,$allowedTypes) && in_array($file_extension,$allowedExtensions)){
									move_uploaded_file($file_source, 'galeria/'.$file_name);
									$this->cropImage('galeria/'.$file_name,'galeria/min/'.$file_name,68,68);

									$db->insert(Index::dbPrefiks.'obrazki', array('nazwa'=>$file_name,'nazwa_prawdziwa'=>$file['name'],'company'=>$id));
								}
								else {
									//	return 'pic_'.$fl;
								}
							}
							else {
								//	return 'pic_'.$fl;
							}
							unset($_FILES['_logo']);
						}
					}
				}

				$smarty = new Smarty;
				$smarty->compile_check = true;
				$smarty->debugging = false;
				$smarty->assign('dane',$dane);
				$body = $smarty->fetch('reg_email.tpl');

				$mail = new Zend_Mail('UTF-8');
				$mail->setBodyHtml($body);
				$mail->setFrom('czas-slubu@czas-slubu.pl', 'Czas Ślubu.pl');
				$mail->addTo('grzegorz.matkowski@dyalcom.pl', 'Czas Ślubu.pl');
				$mail->setSubject('Rejestracja firmy w katalogu');
				$mail->send();

				return 'ok';
			}
			return 9;
		}
		return 9;
	}

	function send_question(){
		$filtr 				= 	new Zend_Filter_StripTags();

		$dane['name'] 		= 	$filtr->filter($_POST['_name']);
		$dane['email'] 		= 	$filtr->filter($_POST['_email']);
		$dane['phone'] 		= 	$filtr->filter($_POST['_phone']);
		$dane['desc'] 		= 	iconv('UTF-8','ISO-8859-2',$filtr->filter($_POST['_desc']));

		$hash = md5($dane['name'].$dane['email'].$dane['phone'].$dane['desc']);

		if(isset($_SESSION['send_hash']) && $hash == $_SESSION['send_hash']){
			return 2;
		}

		if(empty($dane['name']) ){
			return 3;
		}
		
		if(empty($dane['phone']) ){
			return 4;
		}
		
		if(empty($dane['email'])){
			return 5;
		}
		
		
		if(empty($dane['desc']) ){
			return 7;
		}
		
		if(!$this->check_mail_syntax($dane['email'])){
			return 6;
		}
		
		else {
			$smarty = new Smarty;
			$smarty->compile_check = true;
			$smarty->debugging = false;
			$smarty->assign('dane',$dane);
			$body = $smarty->fetch('mail.tpl');

			$mail =	new Zend_Mail('UTF-8');
			$mail->setBodyHtml($body);
			$mail->setFrom($dane['email'], $dane['name']);
			$mail->addTo('taj-india@o2.pl', 'Taj-India');
			$mail->setSubject('Zapytanie od: '.$dane['name']);
			if($mail->send()){
				$_SESSION['send_hash'] = $hash;
				return 1;
			}
		}
	}

	function getSettings(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		return $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."meta WHERE id = 1");

	}
	public function getContent()
	{
		if(!isset($_SESSION['language'])){
			$_SESSION['language'] = 'pl';
		}

		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');
		$id = 0;
		include_once 'kategorie/classKategorie.php';
		include_once 'tresc/classTresc.php';
		include_once 'files/class.files.php';
		include_once 'newsy/classAktualnosci.php';
		include_once 'produkty/classProdukty.php';
		include_once 'gallery/classGalerie.php';
		$content = new Strony();
		$cat = new Kategorie();
		$news = new Aktualnosci();
		$prod = new Produkty();
		$gal = new Galerie();
		$file = new Files();

		$tpl->assign('set',$this->getSettings());
		
//		$tpl->assign('banners',$gal->getZdjeciaAll());

		if(!isset($_GET['strona'])){
			$tpl->assign('content1',$content->getContent(1));
			
			$tpl->assign('content2',$news->getFreshNews());
			$tpl->assign('content3',$content->getContent(2));
			$tpl->assign('include','startowa.tpl');
		}

		if(isset($_POST['send'])){
			$tpl->assign('send_result',$this->send_question());
		}

		if(isset($_GET['strona'])){
			if(isset($_GET['id']))
			$id 			=	(int)$_GET['id'];
			if(isset($_GET['strona']))
			$strona 		=	(int)$_GET['strona'];

			switch($strona){
				case 2:
					$tpl->assign('content',$content->getContentCat($strona,1));
					$tpl->assign('include','tekstowa.tpl');
					break;
				case 3:
					$tpl->assign('content',$news->getNews());
					$tpl->assign('include','aktualnosci.tpl');
					break;	
				case 4:
					$menuu = $cat->getMenu(4);
					if(!empty($menuu)){
					$tpl->assign('menu',$menuu);
					
					if(empty($id))
						$id = $menuu[0]['id'];
					$tpl->assign('content',$content->getContentCat($id,1));	
					}
					$tpl->assign('include','menu.tpl');
					break;	
				case 5:
					
					$tpl->assign('content',$gal->getZdjeciaAll());				
					$tpl->assign('include','galeria.tpl');
					break;	
				case 6:
					$tpl->assign('content',$content->getContentCat($strona,1));				
					$tpl->assign('include','kontakt.tpl');
					break;		
			
				case 666:
					switch($_GET['language']){
						case 'en':
							$_SESSION['language'] = 'en';
							break;
						case 'de':
							$_SESSION['language'] = 'de';
							break;
						case 'ru':
							$_SESSION['language'] = 'ru';
							break;
						default:
							$_SESSION['language'] = 'pl';
							break;
					}
					header('Location: '.$_SERVER['HTTP_REFERER']);
					break;
				default:

					$tpl->assign('include','tekstowa.tpl');
					break;
			}
		}

		$tpl->display('index.tpl');


	}

	public static function toPermalink($string)
	{


		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
		'/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
		'/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
		'/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
		'/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
		'/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
		'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
		'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
		'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
		'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
		'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );

	}

	public static function pathToNode($id,$s='1')
	{
		$db = Zend_Registry::get('db');

		if(!empty($id))
		{
			$sql = "SELECT lleft, rright FROM cms_drzewko WHERE id=".(int)$id;
			$results = $db->fetchAll($sql);

			if(!empty($results))
			{
				$sql = "SELECT * FROM cms_drzewko WHERE lleft <=".$results[0]['lleft']." AND rright >=".$results[0]['rright']." ORDER BY id";
				$results = $db->fetchAll($sql);

				$countResults = count($results);

				$path = null;
				$tab = array();

				for($i=0;$i<$countResults;$i++)
				{
					if($results[$i]['id']==1) $path .= '';
					else if($results[$i]['parent_id']==1) $path .= '';

					else $tab[$i]= ucfirst($results[$i]['nazwa']);
				}

				$path = join(' / ',$tab);
			}
		}

		else $path ='';

		return $path;

	}
}
?>